#!/bin/bash

typeset jsonFile=$1
typeset collectionName=$2
typeset mongoServerName=$3

if [[ -z $jsonFile || -z $collectionName ]]; then
    echo
    echo "Syntax error, check the script usage."
    echo "  Usage:  mongo-import.sh <json file> <collection name> [<mongo server name>]"
    echo "  Options"
    echo "    <json file>: the data file to be load into mongo db"
    echo "    <collection name>: the collection name in mongo db that the data file will be imported"
    echo "    <mongo server name>: optional, default server name is 'vamf_mongo'"
    echo
    exit
fi

if [[ -z $mongoServerName ]]; then
    mongoServerName='vamf_mongo'
fi

typeset jsonFileBasename=`basename $jsonFile`

typeset base=mongoImport
typeset baseShellScript=${base}.sh
typeset deployLog=${base}.log
typeset errorLog=${base}.error
typeset deploymentsDir=$VAGRANT_DIR/deployments
typeset deployScript=${deploymentsDir}/${baseShellScript}

typeset envScript='../set.env.sh'

rm -f $errorLog
mkdir -p $deploymentsDir

if [ -z $VAGRANT_DIR ] || [ ! -r $VAGRANT_DIR/Vagrantfile ] ; then
	echo '$VAGRANT_DIR must be defined and contain a valid Vagrantfile.  Aborted.' > $errorLog
	exit 1
fi

cat <<-'EOF' > ${deployScript}
#!/bin/bash

#mongoimport --ssl --sslAllowInvalidCertificates --db var-utility --collection $2 --drop \
#	--file "/vagrant/deployments/$1" --jsonArray -u var-utility -p var-utility
mongoimport --db var-utility --collection $2 --drop \
	--file "/vagrant/deployments/$1" --jsonArray -u var-utility -p var-utility
EOF

chmod +x $deployScript
cp $jsonFile $deploymentsDir

cd $VAGRANT_DIR
if [[ -f $envScript ]]; then
	. $envScript
fi

vagrant ssh $mongoServerName --command "/vagrant/deployments/$baseShellScript $jsonFileBasename $collectionName > $deployLog 2>&1"